<?php

error_reporting(-1);

use Tygh\Registry;
use Tygh\Http;

if (!defined('BOOTSTRAP')) { die('Access denied'); }

if (!defined('PAYMENT_NOTIFICATION')) {
    $paymentId = $_REQUEST['payment_id'];
    $processor_data = fn_get_payment_method_data($paymentId);
    $orderId = $order_info['order_id'];
    $orderData = fn_get_order_info($orderId);
   
    $current_location = Registry::get('config.http_location');
    $return_url = $current_location . "/index.php?dispatch=payment_notification.notify&payment=cashbill";
    $confData = $orderData['payment_method']['processor_params'];
    $url = $confData['cashbill_test'] == "1" ? "https://pay.cashbill.pl/testws/rest" : "https://pay.cashbill.pl/ws/rest";
 
	$dataArray = array (
			"title" => "Zamówienie nr : " . $orderId,
			"amount.value" => $orderData ['total'],
			"amount.currencyCode" => "PLN",
			"returnUrl" => $return_url . "&success=true&order=" . $orderId,
			"description" => "Płatnośc dla zamówienie o identyfikatorze " . $orderId,
			"negativeReturnUrl" => $return_url . "&success=false&order=" . $orderId,
			"additionalData" => $orderId,
			"referer" => "cscart",
			"personalData.firstName" => $orderData ['firstname'],
			"personalData.surname" => $orderData ['lastname'],
			"personalData.email" => $orderData ['email'],
			"personalData.country" => $orderData ['b_country'],
			"personalData.city" => $orderData ['b_city'],
			"personalData.postcode" => $orderData ['b_zipcode'],
			"personalData.street" => $orderData ['b_address'] . $orderData ['b_address2'] 
	);

    $dataArray ['sign'] = SHA1 ( implode ( "", $dataArray ) . $confData['cashbill_key'] );
    
    $result = Http::post("{$url}/payment/{$confData['cashbill_id']}", $dataArray, array ('headers' => array("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")));
    
    $returnData = json_decode($result);
    
    fn_change_order_status($orderId, 'O', '', false);
    
    header("Location: ".$returnData->redirectUrl);
    exit();
    
} else {
	if ($_GET ['success'] == "true") {
		
		$orderId = $_GET ['order'];
		
		fn_order_placement_routines ( 'route', $orderId );
		
	} elseif ($_GET ['success'] == "false") {
		
		$orderId = $_GET ['order'];
		
		fn_change_order_status ( $orderId, "F" );
		
		fn_order_placement_routines ( 'route', $orderId );
		
	} elseif ($_GET ['notify'] == "true") {
	
			if(isset($_GET['cmd']) && isset($_GET['args'])&& isset($_GET['sign']))
			{
				
				foreach(fn_get_payments() as $payment_method)
				{
					if($payment_method['processor_id'] == "1694")
					{
						$orderData = unserialize($payment_method['processor_params']);
					}
				}
				
				$paymentPointId = $orderData['cashbill_id'];
				$paymentPointKey = $orderData['cashbill_key'];
			
				if (md5 ( $_GET ['cmd'] . $_GET ['args'] . $paymentPointKey ) != $_GET ['sign']) {
						
					echo "BLAD SYGNATURY";
					exit ();
				}
				
				$cashbill_order_id = $_GET['args'];
				$sign = sha1($cashbill_order_id . $paymentPointKey);
                $url = $orderData['cashbill_test'] == "1" ? "https://pay.cashbill.pl/testws/rest" : "https://pay.cashbill.pl/ws/rest";

				$result = Http::get("{$url}/payment/{$paymentPointId}/{$cashbill_order_id}", array('sign'=>$sign), array ('headers' => array("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")));
				
				$paymentInfo = json_decode($result);
			
				$order_id = $paymentInfo->additionalData;
			
			
				if ($paymentInfo->status == "PositiveFinish")
				{
					$response = array('order_status'=>"P",'reason_text'=>'Zamówienie nr : '.$order_id.' zostało poprawnie opłacone.');
					fn_finish_payment($order_id, $response, false);;
				    
				} elseif($paymentInfo->status == "NegativeFinish"){

					$response = array('order_status'=>"F",'reason_text'=>'Zamówienie nr : '.$order_id.' nie zostało poprawnie opłacone.');
					fn_finish_payment($order_id, $response, false);
				}
			
			}
			echo "OK";
			exit();
			
		}
}


?>