<?php

/**
 * Skrypt odbiorczy, komunikacji SERVER-SERVER
 * 
 * @package oscommerce_cashbill_neopay2
 * @subpackage main
 *
 * @copyright 2010 CashBill S.A.
 *
 * @version 1.0 ( 2010.06.18 )
 */

require('includes'. DIRECTORY_SEPARATOR .'application_top.php');

function check_sign($data, $key, $sign) {
	if( md5( $data['service'].$data['orderid'].$data['amount'].$data['userdata'].$data['status'].$key ) == $sign )
		return true;

	if( md5( $data['service'].'|'.$data['orderid'].'|'.$data['amount'].'|'.$data['userdata'].'|'.$data['status'].'|'.$key ) == $sign )
		return true;
		
	return false;		
}

try 
{
	$service	= MODULE_PAYMENT_CASHBILL_SHOPID;
	$key   		= MODULE_PAYMENT_CASHBILL_SECRET_PHRASE;

	if( check_sign( $_POST, $key, $_POST['sign'] ) && $_POST['service'] == $service ) {

		$orderid = $_POST['userdata'];
		$cbTransId = $_POST['orderid']; 
		$status = strtolower( $_POST['status'] );
		
		$sqlAsk = tep_db_query("SELECT * FROM `cashbill_transactions` WHERE `order_id` = ".$orderid." LIMIT 1");
		$sqlDat = tep_db_fetch_array($sqlAsk); 
		
		if( $sqlDat ) {
			if( !$sqlDat['status'] ) {
				$newStatus = $status;
			}
			else {
				if( $sqlDat['status'] != 'ok' && $_POST['status'] == 'ok' )
					$newStatus = $status;
			}
			
			if( $newStatus ) {
				switch ( $newStatus ) {
					case 'ok':
						$status_configuration_key = 'MODULE_PAYMENT_CASHBILL_SUCCESS_ORDER_STATUS_ID';
						break;
					case 'err':
						$status_configuration_key = 'MODULE_PAYMENT_CASHBILL_NEGATIVE_ORDER_STATUS_ID';
						break;
				}
				
				tep_db_query("UPDATE `cashbill_transactions` 
					SET `status` = '".tep_db_prepare_input( $status )."',
						`cbtrans_id` = '".tep_db_prepare_input( $cbTransId )."'
					WHERE `order_id` = '".tep_db_prepare_input( $orderid )."' LIMIT 1;
					");
				tep_db_query("UPDATE `orders` SET `orders_status` = ( SELECT `configuration_value` FROM `". TABLE_CONFIGURATION ."` 
						WHERE `configuration_key` = '".tep_db_prepare_input($status_configuration_key)."' LIMIT 1) 
					WHERE `orders_id` = " . tep_db_prepare_input( $orderid ).";
					");
				tep_db_query("INSERT INTO `orders_status_history` 
					SET `orders_id` = '".tep_db_prepare_input($sqlDat['order_id']) ."', 
						`orders_status_id` = ( SELECT `configuration_value` FROM `". TABLE_CONFIGURATION ."` 
							WHERE `configuration_key` = '".tep_db_prepare_input($status_configuration_key)."' LIMIT 1), 
						`date_added` = '".tep_db_prepare_input(date("Y-m-d H:i:s"))."', 
						`customer_notified` = '0', 
						`comments` = '".tep_db_prepare_input('Transakcja: '.$cbTransId.' Status: '.$status)."';");
			}
		}
	}

	echo 'OK';
}
catch (Exception $exception)
{
	echo 'ERROR: '.$exception->getMessage();
}

die();

?>
