<?php

class cashbill 
{
    var $code, $title, $description, $enabled;

	function cashbill() {
		global $order;
		$this->signature = 'cashbill|cashbill|1.3.1';
      	$this->code = 'cashbill';
      	$this->title = MODULE_PAYMENT_CASHBILL_TEXT_TITLE;
      	$this->description = MODULE_PAYMENT_CASHBILL_TEXT_DESCRIPTION;
      	$this->sort_order = MODULE_PAYMENT_CASHBILL_SORT_ORDER;
      	$this->enabled = ((MODULE_PAYMENT_CASHBILL_STATUS == 'True') ? true : false);

      	if ((int)MODULE_PAYMENT_CASHBILL_ORDER_STATUS_ID > 0)
        	$this->order_status = MODULE_PAYMENT_CASHBILL_ORDER_STATUS_ID;

      	if (is_object($order)) 
      		$this->update_status();
    }

	function check() {
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from ".TABLE_CONFIGURATION." 
				where configuration_key = 'MODULE_PAYMENT_CASHBILL_STATUS' ");
			$this->_check = tep_db_num_rows($check_query);
		}
		return $this->_check;
	}
	function javascript_validation() {
	    return;
	}	
	function selection() {
		return array(
			'id' 		=> $this->code, 
			'module'	=> $this->title
		);
	}
	function pre_confirmation_check() {
		return;		
	}
	function confirmation() {
		return;	
	}
	function before_process() {
	    return;
	}
	function install() {

		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added ) 
		values (
			'Identyfikator sklepu (sysid):', 
			'MODULE_PAYMENT_CASHBILL_SHOPID', 
			'', 
			'Identyfikator sklepu, otrzymany w procesie rejestracji punktu płatności w systemie CashBill S.A.', 
			'6', 
			'1', 
			now()
		);");
		
	    tep_db_query("insert into " . TABLE_CONFIGURATION . " 
	    ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added ) 
	    values ( 
	    	'Tajny klucz sklepu (privkey):', 
	    	'MODULE_PAYMENT_CASHBILL_SECRET_PHRASE', 
	    	'', 
	    	'Tajny klucz sklepu, otrzymany w procesie rejestracji punktu płatności w systemie CashBill S.A.', 
	    	'6', 
	    	'2', 
	    	now()
	    );");
		
		tep_db_query("insert into ".TABLE_CONFIGURATION." 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added ) 
		values ( 
			'Status:', 
			'MODULE_PAYMENT_CASHBILL_STATUS', 
			'False', 
			'Określa czy dana metoda płatności będzie dostępna dla klientów sklepu', 
			'6', 
			'3', 
			'tep_cfg_select_option(array(\'True\', \'False\'), ', 
			now()
		);");
		
		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added ) 
		values ( 
			'Kolejność wyświetlania metody płatności:', 
			'MODULE_PAYMENT_CASHBILL_SORT_ORDER', 
			'0', 
			'Kolejność wyświetlania metody płatności. Metody płatności wyświetlane są na podstawie tej wartości w kolejności od najmniejszej do największej.', 
			'6', 
			'4', 
			now()
		)");
		
		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added ) 
		values ( 
			'Status zamówienia, dla transakcji oczekującej:', 
			'MODULE_PAYMENT_CASHBILL_ORDER_STATUS_ID', 
			'0', 
			'Zamówienia opłacane tą metodą płatności, w przypadku zainicjowanych, niezrealizowanych, bądź nieukończonych transakcji, otrzymają ten status<br />(\'Oczekujący\' - status zalecany)',  
			'6', 
			'5', 
			'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', 
			now()
		)");
		
		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added ) 
		values ( 
			'Status zamówienia, dla transakcji opłaconej:', 
			'MODULE_PAYMENT_CASHBILL_SUCCESS_ORDER_STATUS_ID', 
			'0', 
			'Zamówienia opłacone tą metodą płatności, w przypadku pozytywnie autoryzowanych transakcji, otrzymają ten status<br />(\'Opłacone\' - status zalecany)', 
			'6', 
			'5', 
			'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', 
			now()
		)");
		
		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added ) 
		values ( 
			'Status zamówienia, dla transakcji nieopłaconej:', 
			'MODULE_PAYMENT_CASHBILL_NEGATIVE_ORDER_STATUS_ID',
			'0', 
			'Zamówienia opłacane tą metodą płatności, w przypadku negatywnie autoryzowanych transakcji, otrzymają ten status<br />(\'Nieopłacone\' - status zalecany)', 
			'6', 
			'5', 
			'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', 
			now()
		)");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " 
		( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) 
		values (
			'Płatności tylko dla strefy:', 'MODULE_PAYMENT_CASHBILL_ZONE', 
			'0', 
			'W przypadku wybrania strefy, ta metoda płatności będzie dostępna tylko dla wybranej strefy.', 
			'6', 
			'2', 
			'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', 
			now())");
		
		tep_db_query("CREATE TABLE IF NOT EXISTS `cashbill_transactions` ( 
			`id` int(11) unsigned NOT NULL auto_increment, 
			`cbtrans_id` varchar(12) NOT NULL, 
			`status` varchar(12) NOT NULL, 
			`order_id` int(11) unsigned NOT NULL, 
			`amount` double NOT NULL, 
			`currency` varchar(3) NOT NULL, 
			PRIMARY KEY  (`id`), KEY `cbtrans_id` (`cbtrans_id`) 
			) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;");
	}
	function remove() {
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_STATUS' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_SORT_ORDER' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_ORDER_STATUS_ID' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_SUCCESS_ORDER_STATUS_ID' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_NEGATIVE_ORDER_STATUS_ID' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_ZONE' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_SHOPID' LIMIT 1;");
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where `configuration_key` = 'MODULE_PAYMENT_CASHBILL_SECRET_PHRASE' LIMIT 1;");
	}
	function keys()  {
		return array(
			'MODULE_PAYMENT_CASHBILL_SHOPID',
			'MODULE_PAYMENT_CASHBILL_SECRET_PHRASE',
			'MODULE_PAYMENT_CASHBILL_STATUS',
			'MODULE_PAYMENT_CASHBILL_SORT_ORDER', 
			'MODULE_PAYMENT_CASHBILL_ORDER_STATUS_ID', 
			'MODULE_PAYMENT_CASHBILL_SUCCESS_ORDER_STATUS_ID',
			'MODULE_PAYMENT_CASHBILL_NEGATIVE_ORDER_STATUS_ID',
			'MODULE_PAYMENT_CASHBILL_ZONE',
		);
	}
	function update_status() {
		global $order;
		
		if ( ($this->enabled == true) && defined('MODULE_PAYMENT_CASHBILL_SHOPID') && !constant('MODULE_PAYMENT_CASHBILL_SHOPID'))
			$this->enabled = false;
		
		if ( ($this->enabled == true) && defined('MODULE_PAYMENT_CASHBILL_SECRET_PHRASE') && !constant('MODULE_PAYMENT_CASHBILL_SECRET_PHRASE'))
			$this->enabled = false;

		if ( ($this->enabled == true) && ((int)(constant('MODULE_PAYMENT_CASHBILL_ZONE')) > 0) ) {
			$check_flag = false;
			$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . constant('MODULE_PAYMENT_CASHBILL_ZONE') . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
				    $check_flag = true;
				    break;
				}
				elseif ($check['zone_id'] == $order->delivery['zone_id']) {
				    $check_flag = true;
				    break;
				}
			}
			
			if ($check_flag == false)
				$this->enabled = false;
		}
	}
		
	function after_process() {
		global $order, $currencies, $insert_id, $cart, $languages_id;
		
		try
		{
			if (tep_session_is_registered('cashbill_id')) 
				tep_session_unregister('cashbill_id');
				
			$amount = number_format( $order->info['total']*$order->info['currency_value'], 2 , '.', '');
			$amountC = $order->info['currency'];
				
			tep_db_query("INSERT INTO `cashbill_transactions` 
				(`amount`, `currency`, `order_id` ) 
				VALUES ( '".tep_db_prepare_input($amount)."', '".tep_db_prepare_input($amountC)."', '".tep_db_prepare_input( $insert_id )."' );");
			$cashbill_id = (int)(tep_db_insert_id());
			
			tep_session_register('cashbill_id');
			
			
			$lang = tep_db_fetch_array(tep_db_query("select code from " . TABLE_LANGUAGES . " where languages_id = '" . (int)$languages_id . "'"));
			$lang_code = strtoupper( $lang['code'] );
			
			$service = MODULE_PAYMENT_CASHBILL_SHOPID;
			switch( $lang_code ) {
				case 'PL':
					$desc = 'Zamówienie nr: '.$insert_id;
					break;
				default:
					$desc = 'Order no. '.$insert_id;
					break;
			}
			$userdata = $insert_id;
	
			$sign = md5 ( $service.'|'.$amount.'|'.$amountC.'|'.$desc.'|'.$lang_code.'|'.$userdata.'|'.'oscommerce'.'|'.
			$order->billing['firstname'].'|'.
			$order->billing['lastname'].'|'.
			$order->customer['email_address'].'|'.
			$order->customer['telephone'].'|'.
			$order->billing['street_address'].'|'.
			$order->billing['suburb'].'||'.
			$order->billing['city'].'|'.
			$order->billing['postcode'].'|'.
			$order->billing['country']['title'].'|'.
			MODULE_PAYMENT_CASHBILL_SECRET_PHRASE );

	      	$button = 
	      		tep_draw_hidden_field('service', $service ) .
	      		tep_draw_hidden_field('amount', $amount ) .
	      		tep_draw_hidden_field('desc', $desc ) .
	      		tep_draw_hidden_field('userdata', $userdata ) .
	      		tep_draw_hidden_field('ref', 'oscommerce' ) .
	      		tep_draw_hidden_field('lang', $lang_code ) .
	      		tep_draw_hidden_field('currency', $amountC ) .
	      		tep_draw_hidden_field('forname', $order->billing['firstname'] ) .
	      		tep_draw_hidden_field('surname', $order->billing['lastname'] ) .
	      		tep_draw_hidden_field('email', $order->customer['email_address'] ) .
	      		tep_draw_hidden_field('street', $order->billing['street_address'] ) .
	      		tep_draw_hidden_field('street_n1', $order->billing['suburb'] ) .
	      		tep_draw_hidden_field('city', $order->billing['city'] ) .
	      		tep_draw_hidden_field('postcode', $order->billing['postcode'] ) .
	      		tep_draw_hidden_field('country', $order->billing['country']['title'] ) .
	      		tep_draw_hidden_field('tel', $order->customer['telephone'] ) .
	      		tep_draw_hidden_field('sign', $sign );
	      		
			
			$cart->reset(true);
			tep_session_unregister('sendto');
			tep_session_unregister('billto');
			tep_session_unregister('shipping');
			tep_session_unregister('payment');
			tep_session_unregister('comments');
	
            echo <<<END
<div><form id="cbpaymentform" method="post" action="https://pay.cashbill.pl/form/pay.php">
{$button}
<input type="submit" value="Połącz z operatorem"></form></div>
<script type="text/javascript">
    (function() {
	var form = document.getElementById('cbpaymentform');
	form.style.display='none';
	form.submit();
    })();
</script>
END;
  			require(DIR_WS_INCLUDES . 'application_bottom.php');
  			die();
		}
		catch (Exception $exception)
		{
			$url = tep_href_link('checkout_process.php?try=' );
			echo "<script type=\"text/javascript\">\n".
				"window.location.href = '".$url."';\n".
				"</script>\n";
		}
	}
	
	function process_button() {
		return ;
	}

	
}
